;========================================================================================
; Description:      Twin Ghost - Prototye
; Author(s):        mrbond007 (Baki G)
;					Northwind (Frank Abbing)
;					JPAM (JPAM van der Ouderaa)
;
; Comments:			A new version of the classical Pacman game made with AutoIT
;
;					Remember if you like AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;========================================================================================
If _Singleton("Twin Ghost") = 0 Then Exit

#include "Plugins\ProSpeed.au3"
#include "Plugins\BassMod.au3"
#include "Plugins\Misc.au3"
#include "Plugins\Array.au3"
Opt("GUIOnEventMode", 1)
HotKeySet("{Esc}", "Close")

Global $MainGui, $GTitle = "Twin Ghost"
Global $ResourcePath = @ScriptDir & "\Pacman\"
Global $MPath = $ResourcePath & "Music\"
Global $PPath = $ResourcePath & "Pictures\"
Global $Keys[4] = ["{LEFT}","{RIGHT}","{UP}","{DOWN}"]
Global $XArray[10] = ["35","60","85","110","135","160","185","210","235","260"]
Global $YArray[8] = ["35","60","85","110","135","160","185","210"], $GhostPos
Global $GhostPosArr_A[2][4] = [["259","259","28","28"],["28","209","209","28"]]
Global $GhostPosArr_B[2][4] = [["28","28","259","259"],["28","209","209","28"]]
Global $Blocks[10], $BlockSprite[10], $Trigger = 0, $Dies = 0
Global $RandomBlock = Random(0, 9, 1), $Back, $Numbers[10], $number = 0
Global $Level[2], $Pac, $Pos_X, $Pos_Y, $LvlX = 2, $LvlY = 9, $TargetCandy = ""
GLobal $Spin[4] = ["0","32","64","96"], $PacX, $PacY, $GhostX[2], $GhostY[2]
Global $Candy_id[1], $Block_id[1], $Ghost_id[1], $Block_X_Arr[1], $Block_Y_Arr[1]
Global $aDim, $bDim, $cDim, $bb = -1, $cc = -1, $dd = -1, $z = -1, $y = -1, $Ks = 1, $GameRunning = 1
Global $Sprite1 = $PPath & "pacman2.png", _
		$Sprite2 = $PPath & "ghosts.png", _
		$Sprite3 = $PPath & "level.png", _
		$Sprite4 = $PPath & "numbers.png", _
		$Sprite5 = $PPath & "get.png", _
		$Sprite6 = $PPath & "ready.png", _
		$Sprite7 = $PPath & "candy" & Random(1, 5, 1) & ".png", _
		$Eating = $MPath & "001-System01.wav", _
		$Dying = $MPath & "001-System02.wav", _
		$SugarRush = $MPath & "001-System03.wav"

For $i = 0 To UBound($Blocks)-1
	$Blocks[$i] = $PPath & "block" & $i & ".png"
	$Numbers[$i] = $i
Next

$MainGui = GUICreate($GTitle, 304, 255)
GUISetOnEvent(-3, "Close")
GUISetState()

SplashImageOn("", $PPath & "Art.jpg", 590, 380, -1, -1, 1)
Sleep(5000)
SplashOff()

DSoundInit()
$DidIt = DSoundLoad($Eating)
$Death = DSoundLoad($Dying)
$Speed = DSoundLoad($SugarRush)
$Back = Background($PPath & "back" & $Numbers[$RandomBlock] & ".png", 0, 0, 304, 255)
$PacSprite = loadsprite($Sprite1)
$GhostSprite = loadsprite($Sprite2)
$LevelSprite = loadsprite($Sprite3)
$NumbersSprite = loadsprite($Sprite4)
$GetSprite = loadsprite($Sprite5)
$ReadySprite = loadsprite($Sprite6)
$CandySprite = loadsprite($Sprite7)

For $i = 0 To UBound($BlockSprite)-1
	$BlockSprite[$i] = loadsprite($Blocks[$i])
Next
$TargetSpr = $BlockSprite[$Numbers[$RandomBlock]]
_ArrayDelete($Numbers, $RandomBlock)

$Rnd_Ghost = Random(1, 4, 1)
_PrepareLevel($LvlX, $LvlY)
HotKeys(1)
HotKeySet("z", "Pause")

Ghost_Move()
AdlibEnable("Ghost_Move", 200)
_PrepareTrack($MPath & "Track.it")
_BassVolume(100)

While 1
	Sleep(50)
	_Candy()
	Select
		Case $GameRunning = 0
			FreezeGame()
		Case Collide($Ghost_id[0], $Pac) <> 0 Or Collide($Ghost_id[1], $Pac) <> 0
			Pacman_Dies()
	EndSelect
WEnd

Func _PrepareLevel($From_X, $To_Y)
	Local $SpecialCandy = 1, $RandomGhostMove = Random(0, 3, 1), $RandomCandy
	Dim $z = -1, $y = -1, $GhostPos = ""

	If $RandomGhostMove = 0 Or $RandomGhostMove = 2 Then
		$GhostPos = $GhostPosArr_A
	Else
		$GhostPos = $GhostPosArr_B
	EndIf

	_ShowLevel_Info()
	For $a = $From_X To $To_Y
		$ReadLine = FileReadLine(@ScriptDir & "\Pacman\Levels.txt", $a) ;read the numbers from the levels.txt file
		$Data = StringSplit($ReadLine, "")
		For $b = 1 To $Data[0]
			If $Data[$b] = 0 Then ;0 stands for pacman (only one pacman is allowed)
				$Pac = sprite($PacSprite, 0, 0, 30, 30, 12, 1, 0, ($XArray[$b-1])-10, ($YArray[$a-$From_X])-10)
				SetSpriteSpeed($Pac, 2, 2)
				SetSpriteAnim($Pac, 0, 0, 32, 32, 3, 1, 7)
			ElseIf $Data[$b] = 1 Then ;1 stands for candy
				$aDim += 1
				$bb += 1
				ReDim $Candy_id[$aDim]
				$Candy_id[$bb] = sprite($CandySprite, 0, 0, 13, 13, 1, 1, 0, $XArray[$b-1], $YArray[$a-$From_X])
				If $SpecialCandy = 1 Then
					$SpecialCandy = 0
					$Rush = Random(0, 9, 1)
					If $Rush = 3 Or $Rush = 7 Then $TargetCandy = $Candy_id[$bb]
				EndIf
			ElseIf $Data[$b] = 2 Then ;2 stands for ghost
				$bDim += 1
				$cc += 1
				ReDim $Ghost_id[$bDim]
				$Ghost_id[$cc] = sprite($GhostSprite, 0, 0, 21, 21, 4, $Rnd_Ghost, 0, ($XArray[$b-1])-6, ($YArray[$a-$From_X])-6)
				SetSpriteSpeed($Ghost_id[$cc], 4, 4)
			ElseIf $Data[$b] = 3 Then ;3 stands for blocks
				$cDim += 1
				$dd += 1
				ReDim $Block_id[$cDim]
				ReDim $Block_X_Arr[$cDim]
				ReDim $Block_Y_Arr[$cDim]
				$Block_id[$dd] = sprite($TargetSpr, 0, 0, 25, 25, 1, 1, 0, ($XArray[$b-1])-8, ($YArray[$a-$From_X])-8)
				$Block_X_Arr[$dd] = ($XArray[$b-1])-8
				$Block_Y_Arr[$dd] = ($YArray[$a-$From_X])-8
			EndIf
		Next
	Next

	Dim $aDim = "", $bDim = "", $cDim = "", $bb = -1, $cc = -1, $dd = -1
	$Pos_X = GetSpriteX($Pac)
	$Pos_Y = GetSpriteY($Pac)
EndFunc

Func _ShowLevel_Info() ;displays level count
	Local $TargetX, $TargetY, $SplitX, $SplitY

	If $Dies = 0 Then
		$number += 1
		If $Trigger = 5 Then ;change background and blocks every 5 levels
			$Trigger = 0
			FreeExtBmp($Back)
			$RandomBlock = Random(0, UBound($Numbers)-1, 1)
			$Back = Background($PPath & "back" & $Numbers[$RandomBlock] & ".png", 0, 0, 304, 255)
			$TargetSpr = $BlockSprite[$Numbers[$RandomBlock]]
			_ArrayDelete($Numbers, $RandomBlock)
		EndIf
		$Trigger += 1
		$Level[0] = sprite($LevelSprite, 0, 0, 61, 21, 1, 1, 0, -100, 120) ;displays level number
		$Level[1] = sprite($NumbersSprite, 0, 0, 32, 29, 20, $number, 0, 350, 116)
		$TargetX = "100,120"
		$TargetY = "175,116"
	Else
		$Level[0] = sprite($GetSprite, 0, 0, 44, 21, 1, 1, 0, -170, 120) ;displays "Get Ready"
		$Level[1] = sprite($ReadySprite, 0, 0, 70, 21, 1, 1, 0, 350, 120)
		$TargetX = "90,120"
		$TargetY = "150,120"
	EndIf

	$SplitX = StringSplit($TargetX, ",")
	$SplitY = StringSplit($TargetY, ",")
	SetSpriteSpeed($Level[0], 5, 5)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], $SplitX[1], $SplitX[2])
	MoveSprite($Level[1], $SplitY[1], $SplitY[2])
	Sleep(3500)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])
EndFunc

Func HotKeys($Param) ;enables/disables hotkeys
	If $Param = 0 Then
		For $i = 0 To UBound($Keys)-1
			HotKeySet($Keys[$i])
		Next
	Else
		For $i = 0 To UBound($Keys)-1
			HotKeySet($Keys[$i], "Key_Pressed")
		Next
	EndIf
EndFunc

Func Key_Pressed() ;used to see which key you pressed
	If HasSpriteArrived($Pac) = 1 And WinActive($MainGui) Then ;did pacman reach the destination
		Select
			Case @HotKeyPressed = "{LEFT}"
				ChangeSpritePara($Pac, 8, 0) ;changes how pacman looks
				For $i = 0 To UBound($Block_X_Arr)-1 ;used to see if pacman has reached a block
					If $Pos_X = ($Block_X_Arr[$i])+23 And $Pos_Y = ($Block_Y_Arr[$i])-2 Then
						Return 0
					EndIf
				Next
				$Pos_X -= 25 ;calculates pacman's next move
				If $Pos_X <= 25 Then $Pos_X = 25 ;creates a limit so pacman can't go outside the background
			Case @HotKeyPressed = "{RIGHT}"
				ChangeSpritePara($Pac, 8, 32)
				For $i = 0 To UBound($Block_X_Arr)-1
					If $Pos_X = ($Block_X_Arr[$i])-27 And $Pos_Y = ($Block_Y_Arr[$i])-2 Then
						Return 0
					EndIf
				Next
				$Pos_X += 25
				If $Pos_X >= 250 Then $Pos_X = 250
			Case @HotKeyPressed = "{UP}"
				ChangeSpritePara($Pac, 8, 64)
				For $i = 0 To UBound($Block_X_Arr)-1
					If $Pos_X = ($Block_X_Arr[$i])-2 And $Pos_Y = ($Block_Y_Arr[$i])+23 Then
						Return 0
					EndIf
				Next
				$Pos_Y -= 25
				If $Pos_Y <= 25 Then $Pos_Y = 25
			Case @HotKeyPressed = "{DOWN}"
				ChangeSpritePara($Pac, 8, 96)
				For $i = 0 To UBound($Block_X_Arr)-1
					If $Pos_X = ($Block_X_Arr[$i])-2 And $Pos_Y = ($Block_Y_Arr[$i])-27 Then
						Return 0
					EndIf
				Next
				$Pos_Y += 25
				If $Pos_Y >= 200 Then $Pos_Y = 200
		EndSelect
		MoveSprite($Pac, $Pos_X, $Pos_Y) ;move pacman
	EndIf
EndFunc

Func Ghost_Move() ;controls the twins (the ghosts, not what you had in mind O.O)
	$GhostX[0] = GetSpriteX($Ghost_id[0])
	$GhostY[0] = GetSpriteY($Ghost_id[0])
	$GhostX[1] = GetSpriteX($Ghost_id[1])
	$GhostY[1] = GetSpriteY($Ghost_id[1])
	If HasSpriteArrived($Ghost_id[0]) = 1 Then
		If $z = 3 Then $z = -1
		$z += 1
		MoveSprite($Ghost_id[0], $GhostPos[0][$z], $GhostPos[1][$z])
	EndIf
	If HasSpriteArrived($Ghost_id[1]) = 1 Then
		If $y = 3 Then $y = -1
		$y += 1
		MoveSprite($Ghost_id[1], $GhostPos[0][$y], $GhostPos[1][$y])
	EndIf
EndFunc

Func _Candy() ;pacman's food function
	For $i = 0 To UBound($Candy_id)-1
		Select
			Case Collide($Pac, $Candy_id[$i]) <> 0 ;did pacman reach a piece of candy?
				If $TargetCandy = $Candy_id[$i] Then ;if it's a special candy?
					$Rush = Random(0, 3, 1)
					If $Rush = 0 Or $Rush = 2 Then
						SetSpriteSpeed($Pac, 5, 5) ;activate sugar rush (speeds pacamn)
					Else
						SetSpriteSpeed($Pac, 3, 3)
						SetSpriteSpeed($Ghost_id[0], 1, 1) ;activate sugar rush (Slows the twins)
						SetSpriteSpeed($Ghost_id[1], 1, 1)
					EndIf
					$TargetCandy = ""
					DSoundPlay($Speed, 0, 0)
				Else ;no special candy
					DSoundPlay($DidIt, 0, 0)
				EndIf
				DeleteSprite($Candy_id[$i]) ;eats the candy
				If UBound($Candy_id) > 1 Then
					_ArrayDelete($Candy_id, $i)
				Else
					Level_Finished() ;when there is no more candy the level finishes
				EndIf
				Return 0
		EndSelect
	Next
EndFunc

Func Pause() ;prepares the game to be paused
	If $Ks = 1 Then
		$Ks = 0
		$GameRunning = 0 ;declared in the main loop (used to stop the game)
		_PauseMusic()
		HotKeys(0)
		AdlibDisable()
		$GhostX[0] = GetSpriteX($Ghost_id[0])
		$GhostY[0] = GetSpriteY($Ghost_id[0])
		$GhostX[1] = GetSpriteX($Ghost_id[1])
		$GhostY[1] = GetSpriteY($Ghost_id[1])
		SetSpritePos($Ghost_id[0], $GhostX[0], $GhostY[0], $GhostX[0], $GhostY[0])
		SetSpritePos($Ghost_id[1], $GhostX[1], $GhostY[1], $GhostX[1], $GhostY[1])
		WinSetTitle($MainGui, "", "Paused")
	Else
		$Ks += 1
		$GameRunning = 1
		_PlayMusic()
		HotKeys(1)
		MoveSprite($Ghost_id[0], $GhostPos[0][$z], $GhostPos[1][$z])
		MoveSprite($Ghost_id[1], $GhostPos[0][$y], $GhostPos[1][$y])
		AdlibEnable("Ghost_Move", 200)
		WinSetTitle($MainGui, "", $GTitle)
	EndIf
EndFunc

Func FreezeGame() ;pauses the game
	Do
		Sleep(50)
	Until $GameRunning = 1 ;until you repress the z key which will set $GameRunning to 0
EndFunc

Func Level_Finished() ;if level has finished
	HotKeys(0)
	HotKeySet("z")

	AdlibDisable()
	DeleteAllSprites()
	If $LvlX = 192 Then Close() ;exit the game when it reaches the end of levels.txt
	$LvlX += 10
	$LvlY += 10
	_PrepareLevel($LvlX,$LvlY) ;creates the next level
	Ghost_Move()
	AdlibEnable("Ghost_Move", 200)

	HotKeys(1)
	HotKeySet("z", "Pause")
EndFunc

Func Pacman_Dies() ;when pacman gets killed - resets everything and recreates the level
	Dim $z = -1, $y = -1
	$GhostX[0] = GetSpriteX($Ghost_id[0])
	$GhostY[0] = GetSpriteY($Ghost_id[0])
	$GhostX[1] = GetSpriteX($Ghost_id[1])
	$GhostY[1] = GetSpriteY($Ghost_id[1])
	$Pos_X = GetSpriteX($Pac)
	$Pos_Y = GetSpriteY($Pac)
	MoveSprite($Ghost_id[0], $GhostX[0], $GhostY[0])
	MoveSprite($Ghost_id[1], $GhostX[1], $GhostY[1])
	MoveSprite($Pac, $Pos_X, $Pos_Y)

	AdlibDisable()
	HotKeys(0)
	HotKeySet("z")
	DSoundPlay($Death, 0, 0)
	For $a = 0 To 3
		For $i = 0 To 3
			ChangeSpritePara($Pac, 8, $Spin[$i]) ;spins pacman around
			Sleep(100)
		Next
		Sleep(50)
	Next

	DeleteAllSprites()
	$Dies = 1
	_PrepareLevel($LvlX, $LvlY) ;recreates the level
	$Dies = 0
	HotKeys(1)
	HotKeySet("z", "Pause")
	Ghost_Move()
	AdlibEnable("Ghost_Move", 200)
EndFunc

Func Close() ;frees the resources and closes the game
	HotKeySet("{ESC}")
	HotKeySet("z")
	AdlibDisable()
	FreeExtBmp($Back)
	DeleteAllSprites()
	_StopMusic()
	_FreeBass()
	GUIDelete($MainGui)
	SplashImageOn("", $PPath & "GOTFP.jpg", 272, 75, -1, -1, 1)
	Sleep(3500)
	SplashOff()
	Exit
EndFunc